/********************************************************
**                B T D   S Y S T E M S                **
**                =====================                **
** PeerCtrl Library								       **
** 2002 Edward Powley                                 **
*********************************************************
** Created on 18-Aug-02                                **
********************************************************/

#include "windows.h"
#include "../mdk/mdk.h"
#include <float.h>
#include <stdlib.h>
#include <math.h>
#include "peerctrl.h"

#include "hack.h"

////////////////////////////////////////////////////////////////////////

class CMyDataOut : public CMachineDataOutput
//A data out class for receiving machine names
{
public:
	CMyDataOut();
	~CMyDataOut();
	virtual void Write(void *pbuf, int const numbytes);

	HWND DlgItem;
	int CtrlID;
	int CtrlAddMessage;

	char ExclName [128];
	int Count;
};

CMyDataOut::CMyDataOut()
	: Count(0)
{
}

CMyDataOut::~CMyDataOut()
{
}

void CMyDataOut::Write(void *pbuf, const int numbytes)
{
	if (strcmp((char*)pbuf, ExclName) != 0)
	{
		SendMessage(DlgItem, 
			CtrlAddMessage, 0, (LPARAM)(LPCTSTR)(pbuf));
		Count++;
	}
}

////////////////////////////////////////////////////////////////////////

CPeerCtrl::CPeerCtrl(CMachine *pmac, CMachineInterface *pmi)
{
	pCB = pmi->pCB;
	ParentMac = pmac;
	FindMIOffset(pmac, pmi);
	HavePar = false;
	JustLoaded = false;
}

////////////////////////////////////////////////////////////////////////

CPeerCtrl::~CPeerCtrl()
{
}

////////////////////////////////////////////////////////////////////////

inline void ReadString (char *temp, CMachineDataInput * const pi)
//Read a null-terminated string from a CMachineDataInput
{
	byte inch;
	int i=0;

	do
	{
		pi->Read(inch);
		*temp = char(inch);
		temp++;
		i++;
	}
	while (inch != 0);
}

////////////////////////////////////////////////////////////////////////

inline void WriteString (const char *temp, CMachineDataOutput * const po)
//Write a null-terminated string to a CMachineDataOutput
{
	byte outch;
	int i=0;
	do
	{
		outch = *temp;
		temp++;
		po->Write(outch);
		i++;
	}
	while (outch != 0);
}

////////////////////////////////////////////////////////////////////////

void CPeerCtrl::ReadFileData(CMachineDataInput * const pi)
{
	if (pi != NULL) //Read data from file
	{
		byte Version;
		pi->Read(Version);
		if (Version == 1)
		{
			byte HasPar;
			pi->Read(HasPar);
			if (HasPar != 0)
			{
				ReadString(JustLoadedMacName, pi);
				pi->Read(BusParNo);
				pi->Read(BusGroup);
				HavePar = true;
				JustLoaded = true;
			}
			else
				HavePar = false;
		}
		else
			MessageBox (NULL, "Incompatible data", "Error",
						MB_OK|MB_SYSTEMMODAL);
	}
}

////////////////////////////////////////////////////////////////////////

void CPeerCtrl::WriteFileData(CMachineDataOutput * const po)
{
	po->Write(byte(1));	//version
	if (HavePar)
	{
		po->Write(byte(0xFF));
		WriteString (pCB->GetMachineName (BusMachine), po);
		po->Write(BusParNo);
		po->Write(BusGroup);
	}
	else
		po->Write(byte(0));
}

////////////////////////////////////////////////////////////////////////

int CPeerCtrl::GetMachineNamesToCombo(HWND hWnd, int ComboID, const char *ExcludeName)
{
	CMyDataOut dout;

	dout.DlgItem = GetDlgItem(hWnd, ComboID);
	dout.CtrlAddMessage = CB_ADDSTRING;
	strcpy (dout.ExclName, ExcludeName);
	
	SendMessage(dout.DlgItem, CB_RESETCONTENT, 0, 0);
	pCB->GetMachineNames(&dout);
	
	return dout.Count;
}

////////////////////////////////////////////////////////////////////////

int CPeerCtrl::GetMachineNamesToList(HWND hWnd, int ListID, const char *ExcludeName)
{
	CMyDataOut dout;

	dout.DlgItem = GetDlgItem(hWnd, ListID);
	dout.CtrlAddMessage = LB_ADDSTRING;
	strcpy (dout.ExclName, ExcludeName);
	
	SendMessage(dout.DlgItem, LB_RESETCONTENT, 0, 0);
	pCB->GetMachineNames(&dout);
	
	return dout.Count;
}

////////////////////////////////////////////////////////////////////////

int CPeerCtrl::GetParamNames(CMachine *pmac, HWND DlgItem, int AddMessage, int TypesAllowed)
{
	const CMachineInfo *minfo = pCB->GetMachineInfo(pmac);
	const CMachineParameter *par;
	char txt[256];
	int count = 0;

	if (TypesAllowed & ALLOW_GLOBAL)
	{
		for (int p=0; p < minfo->numGlobalParameters; p++)
		{
			par = minfo->Parameters[p];
			if (	((par->Type == pt_switch)	&& (TypesAllowed & ALLOW_SWITCH))
				||	((par->Type == pt_byte)		&& (TypesAllowed & ALLOW_BYTE))
				||	((par->Type == pt_note)		&& (TypesAllowed & ALLOW_NOTE))
				||	((par->Type == pt_word)		&& (TypesAllowed & ALLOW_WORD)))
			{
				sprintf(txt, "[G] %i: %s", p, par->Name);
				SendMessage(DlgItem, 
					AddMessage, 0, (LPARAM)(LPCTSTR)(txt));
				count++;
			}
		}
	}

	if (TypesAllowed & ALLOW_TRACK)
	{
		for (int p=0; p < minfo->numTrackParameters; p++)
		{
			par = minfo->Parameters[p + minfo->numGlobalParameters];
			if (	((par->Type == pt_switch)	&& (TypesAllowed & ALLOW_SWITCH))
				||	((par->Type == pt_byte)		&& (TypesAllowed & ALLOW_BYTE))
				||	((par->Type == pt_note)		&& (TypesAllowed & ALLOW_NOTE))
				||	((par->Type == pt_word)		&& (TypesAllowed & ALLOW_WORD)))
			{
				sprintf(txt, "[T] %i: %s", p, par->Name);
				SendMessage(DlgItem, 
					AddMessage, 0, (LPARAM)(LPCTSTR)(txt));
				count++;
			}
		}
	}

	return count;
}

////////////////////////////////////////////////////////////////////////

int CPeerCtrl::GetParamNamesToCombo(CMachine *pmac, HWND hWnd, int ComboID, int TypesAllowed)
{
	SendMessage(GetDlgItem(hWnd, ComboID), CB_RESETCONTENT, 0, 0);
	return GetParamNames(pmac, GetDlgItem(hWnd, ComboID), CB_ADDSTRING, TypesAllowed);
}

int CPeerCtrl::GetParamNamesToList(CMachine *pmac, HWND hWnd, int ListID, int TypesAllowed)
{
	SendMessage(GetDlgItem(hWnd, ListID), LB_RESETCONTENT, 0, 0);
	return GetParamNames(pmac, GetDlgItem(hWnd, ListID), LB_ADDSTRING, TypesAllowed);
}

////////////////////////////////////////////////////////////////////////

int CPeerCtrl::FindMachine(HWND DlgItem, int SelectStringMessage)
{
	return SendMessage(DlgItem, 
		SelectStringMessage, 
		0, (LPARAM)(GetMachineName()));
}

bool CPeerCtrl::FindParam(HWND DlgItem, int SelectStringMessage)
{
	return (SendMessage(DlgItem, 
		SelectStringMessage, 
		0, (LPARAM)(GetParamString())) != CB_ERR);
}

////////////////////////////////////////////////////////////////////////

bool CPeerCtrl::SelectMachineInCombo(HWND hWnd, int ComboID)
{
	int t = FindMachine(GetDlgItem(hWnd, ComboID), CB_FINDSTRINGEXACT);
	if (t != CB_ERR)
	{
		SendMessage(GetDlgItem(hWnd, ComboID),
			CB_SETCURSEL,
			t, 0);
		return true;
	}
	else
		return false;
}

bool CPeerCtrl::SelectMachineInList(HWND hWnd, int ListID)
{
	int t = FindMachine(GetDlgItem(hWnd, ListID), LB_FINDSTRINGEXACT);
	if (t != LB_ERR)
	{
		SendMessage(GetDlgItem(hWnd, ListID),
			LB_SETCURSEL,
			t, 0);
		return true;
	}
	else
		return false;
}

////////////////////////////////////////////////////////////////////////

bool CPeerCtrl::SelectParameterInCombo(HWND hWnd, int ComboID)
{
	return FindParam(GetDlgItem(hWnd, ComboID), CB_SELECTSTRING);
}

bool CPeerCtrl::SelectParameterInList(HWND hWnd, int ListID)
{
	return FindParam(GetDlgItem(hWnd, ListID), LB_SELECTSTRING);
}

////////////////////////////////////////////////////////////////////////

void CPeerCtrl::AssignParameter(CMachine *pMachine, int Group, int Param)
{
	BusMachine = pMachine;

	if (BusMachine != NULL)
	{
		HavePar = true;
		BusGroup = Group;
		BusParNo = Param;
		const CMachineInfo *minfo = pCB->GetMachineInfo(BusMachine);
		if (BusGroup == 1)
			BusPar = minfo->Parameters[BusParNo];
		else
			BusPar = minfo->Parameters[BusParNo + minfo->numGlobalParameters];
	}
}

void CPeerCtrl::AssignParameter(char *MacName, char *ParaName)
// [G] 1: Cutoff
// 0123456
{
	BusMachine = pCB->GetMachine(MacName);

	if (BusMachine != NULL)
	{
		HavePar = true;
		BusGroup = (ParaName[1] == 'G') ? 1 : 2;
		BusParNo = atoi(ParaName+4);
		const CMachineInfo *minfo = pCB->GetMachineInfo(BusMachine);
		if (BusGroup == 1)
			BusPar = minfo->Parameters[BusParNo];
		else
			BusPar = minfo->Parameters[BusParNo + minfo->numGlobalParameters];
	}
}

////////////////////////////////////////////////////////////////////////

void CPeerCtrl::UnassignParameter()
{
	HavePar = false;
}

////////////////////////////////////////////////////////////////////////

CMachineParameter const *CPeerCtrl::GetParamInfo()
{
	if (GotParam())
		return BusPar;
	else
		return NULL;
}

////////////////////////////////////////////////////////////////////////

char const *CPeerCtrl::GetParamString()
{
	static char txt[256];
	sprintf (txt, "[%s] %i: %s",
		(BusGroup == 1) ? "G" : "T",
		BusParNo,
		BusPar->Name);
	return txt;
}

////////////////////////////////////////////////////////////////////////

CMachine *CPeerCtrl::GetMachine()
{
	if (GotParam())
		return BusMachine;
	else
		return NULL;
}

////////////////////////////////////////////////////////////////////////

char const *CPeerCtrl::GetMachineName()
{
	if (GotParam())
		return pCB->GetMachineName(BusMachine);
	else
	{
		if (JustLoaded)
			return JustLoadedMacName;
		else
			return NULL;
	}
}

////////////////////////////////////////////////////////////////////////

CMachineInfo const *CPeerCtrl::GetMInfo()
{
	if (GotParam())
		return pCB->GetMachineInfo(BusMachine);
	else
		return NULL;
}

////////////////////////////////////////////////////////////////////////

CMachineInterface *CPeerCtrl::GetMInterface()
{
	if (GotParam())
		return GetMI(BusMachine);
	else
		return NULL;
}

////////////////////////////////////////////////////////////////////////

char const *CPeerCtrl::GetAssignmentString()
{
	static char txt[256];
	if (GotParam())
		sprintf(txt,"%s->%s",pCB->GetMachineName(BusMachine),BusPar->Name);
	else
		sprintf(txt,"No assign");
	return txt;
}

////////////////////////////////////////////////////////////////////////

bool CPeerCtrl::CheckMachine()
{
	if (HavePar)
	{
		if (JustLoaded) //The machine was just loaded in a song file
		{
			BusMachine = pCB->GetMachine (JustLoadedMacName);

			if (BusMachine == NULL)
			{
				char txt[1024];
				sprintf(txt,"Machine named '%s' could not be found.\n"
					"Hence machine %s needs reassigning.\n"
					"Reasons:\n"
					"* the file could be corrupted\n"
					"* it is a bug - it happens sometimes :( If you get "
					"this message frequently, please let me know",
					JustLoadedMacName,
					pCB->GetMachineName(ParentMac));
				MessageBox(NULL,txt,"Error",MB_OK);

				HavePar = false;
				JustLoaded = false;
				return false;
			}
			else
			{
				const CMachineInfo *minfo = pCB->GetMachineInfo(BusMachine);

				if (BusGroup == 1) //Global
					BusPar = minfo->Parameters[BusParNo];
				else
					BusPar = minfo->Parameters[BusParNo + minfo->numGlobalParameters];

				JustLoaded = false;
				HavePar = CheckMachine();

				return HavePar;
			}
		}
		else // if (!JustLoaded)
		{
			CMachine * NewMac = pCB->GetMachine (pCB->GetMachineName (BusMachine));
			
			
			if (NewMac != BusMachine) //Something is amiss! (Should be the same)
			{
				HavePar = false;
				return false;
			}
			else
				return true;
		}
	}
	else
		return false;
}

////////////////////////////////////////////////////////////////////////

bool CPeerCtrl::GotParam()
{
	return (HavePar && !JustLoaded);
}

////////////////////////////////////////////////////////////////////////

void CPeerCtrl::ControlChange_Immediate(int track, int value)
{
	if (GotParam() && (track < GetMInfo()->maxTracks || BusGroup == 1))
	{
		Hack_ControlsClear(pCB->GetMachineInfo(BusMachine), BusMachine);
		Hack_ControlChange(pCB->GetMachineInfo(BusMachine),
			BusMachine,
			BusGroup,
			track,
			BusParNo,
			value);
		GetMI(BusMachine)->Tick();
	}
}

////////////////////////////////////////////////////////////////////////

void CPeerCtrl::ControlChange_NextTick(int track, int value)
{
	if (GotParam())
	{
		pCB->ControlChange(BusMachine,
			BusGroup,
			track,
			BusParNo,
			value);
	}
}


////////////////////////////////////////////////////////////////////////

// added CPeerCtrlNote class -jmmcd

CPeerCtrlNote::CPeerCtrlNote(CPeerCtrl *note,
								  CPeerCtrl *vol, CPeerCtrl *length, CPeerCtrl *slide) {
		note_ctrl = note;
		vol_ctrl = vol;
		length_ctrl = length;
		slide_ctrl = slide;
}

CPeerCtrlNote::~CPeerCtrlNote() {}


// only the note controller is guaranteed to be correctly assigned.
// we call GotParam() for each parameter *here* - the user of this fn
// *must* call it for note_ctrl, but the others are optional.
void CPeerCtrlNote::ControlChange_Immediate(int track, 
											int note,
											int volume, int length, int slide) {
	
/*	char txt[256];
	sprintf(txt, "track: %d; note: %d; volume: %d; length: %d; slide: %d",
		track, note, volume, length, slide);
	MessageBox(NULL, // dunno what NULL signifies
			txt, // message text
			"Debug", // window title
			MB_OK|MB_SYSTEMMODAL); // an ok button
*/
	assert (note_ctrl);
	assert (vol_ctrl);
	assert (length_ctrl);
	assert (slide_ctrl);

	if (note_ctrl->GotParam() 
		&& (track < note_ctrl->GetMInfo()->maxTracks 
		|| note_ctrl->BusGroup == 1)) {

		Hack_ControlsClear(
			note_ctrl->pCB->GetMachineInfo(note_ctrl->BusMachine), note_ctrl->BusMachine);
		/*Hack_ControlsClear(
			vol_ctrl->pCB->GetMachineInfo(vol_ctrl->BusMachine), vol_ctrl->BusMachine);*/
		
		Hack_ControlChange(note_ctrl->pCB->GetMachineInfo(note_ctrl->BusMachine),
			note_ctrl->BusMachine,
			note_ctrl->BusGroup,
			track,
			note_ctrl->BusParNo,
			note);

		if (vol_ctrl && vol_ctrl->GotParam()) {
			Hack_ControlChange(vol_ctrl->pCB->GetMachineInfo(vol_ctrl->BusMachine),
				vol_ctrl->BusMachine,
				vol_ctrl->BusGroup,
				track,
				vol_ctrl->BusParNo,
				volume);
		}

		if (length_ctrl && length_ctrl->GotParam()) {
			Hack_ControlChange(length_ctrl->pCB->GetMachineInfo(length_ctrl->BusMachine),
				length_ctrl->BusMachine,
				length_ctrl->BusGroup,
				track,
				length_ctrl->BusParNo,
				length);
		}
		if (slide_ctrl && slide_ctrl->GotParam()) {
			Hack_ControlChange(slide_ctrl->pCB->GetMachineInfo(slide_ctrl->BusMachine),
				slide_ctrl->BusMachine,
				slide_ctrl->BusGroup,
				track,
				slide_ctrl->BusParNo,
				slide);
		}
		
		GetMI(note_ctrl->BusMachine)->Tick();
	}
}
